#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "ctrl/BOLTPictures.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brPreview.h"
#include "report/brQuery.h"
#include "wx/statline.h"
enum {
ID_HEIGHT=15757,
ID_WIDTH,
ID_MLEFT,
ID_MRIGHT,
ID_MTOP,
ID_MBOTTOM,
ID_PREVIEW
};

//IMPLEMENT_DYNAMIC_CLASS(brPreview,wxPanel)
BEGIN_EVENT_TABLE(brPreview,wxPanel)
EVT_LEFT_DOWN(OnMouseDown)  
EVT_LEFT_UP(OnMouseUp)  
EVT_LEFT_DCLICK(OnMouseDClick)  
EVT_MOTION(OnMouseMotion)  
EVT_ENTER_WINDOW(OnMouseEnter) 
EVT_LEAVE_WINDOW(OnMouseLeave) 
END_EVENT_TABLE()

brPreview::brPreview(wxWindow *parent,BOLTdb *db, RECORD_ID recordId):
 wxPanel(parent,-1)
{
	 created=false;
	 this->db=db;
	 this->recordId=recordId;
	SetFont(parent->GetFont());
	hotQuery=0;
SetBackgroundColour(parent->GetBackgroundColour());

wxBoxSizer *topSizer;
topSizer=new wxBoxSizer(wxVERTICAL);
topSizer->Add(new wxStaticText(this,-1,"Preview"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);
topSizer->Add(10,10,0,wxEXPAND);
topSizer->Add(new wxStaticBitmap(this,ID_PREVIEW,wxBitmap(85*2,110*2)),0,wxALIGN_CENTER);

//SetAutoLayout(TRUE);
SetSizerAndFit(topSizer);
created=true;
//Refresh();
};

double brPreview::dbVal(const char *field)
{
char *tmp;
if (tmp=db->GetValue("reportLayouts",field,recordId))
{ return atof(tmp); }
else
{ return 0; }
}

	void brPreview::DrawPreview()
{
	//decide on scale factor
	//availX, availY
	//imageX, imageY

	//scaleX, scaleY
	wxMemoryDC *memDC=new wxMemoryDC();
	wxStaticBitmap *bitmapCtrl;
	bitmapCtrl=(wxStaticBitmap *)this->FindWindow(ID_PREVIEW);

	wxString tStr;
	int availX;
	int availY;
	double scale;
	double imageX,imageY;
	availX=bitmapCtrl->GetSize().x;
	availY=bitmapCtrl->GetSize().y;
	int useX=20;
	int useY=10;

	wxBitmap *bitmap;
	bitmap=new wxBitmap(availX,availY);
	tStr=db->GetValue("reportLayouts","width",recordId);
	if (!tStr.ToDouble(&imageX))
		{ imageX=7.9;db->SetValue("reportLayouts","width",recordId,"7.9");}

	tStr=db->GetValue("reportLayouts","height",recordId);
	if (!tStr.ToDouble(&imageY))
		{ imageY=10.45; db->SetValue("reportLayouts","height",recordId,"10.45"); }

	if ((double)(imageX/availX)>double(imageY/availY))
	{
		scale=(availX-2*useX)/imageX;
	}
	else
	{
		scale=(availY-2*useY)/imageY;
	}

	int pixL,pixR,pixT,pixB;
	int offX,offY;

	offX=(availX-(imageX*scale))/2;
	offY=(availY-(imageY*scale))/2;
	pixL=offX;
	pixR=imageX*scale;
	pixT=offY;
	pixB=imageY*scale;
	//memoryDC - building a bitmap
	memDC->SelectObject(*bitmap);
	wxBrush tBrush(*wxWHITE_BRUSH);
	tBrush.SetStyle(wxSOLID);
	tBrush.SetColour("LIGHT GREY");
	memDC->SetBrush(tBrush);
					
	memDC->Clear();

	memDC->DrawRectangle(0,0,availX,availY);
	memDC->SetBrush(wxNullBrush);
	if ((pixR>0)&&(pixB>0))
	{

		memDC->SetPen(*wxWHITE_PEN);
		memDC->DrawRectangle(pixL-1,pixT-1,pixR+1,pixB+1); 
		memDC->SetPen(*wxGREY_PEN);
		memDC->DrawRectangle(pixL+1,pixT+1,pixR,pixB); 

		memDC->SetPen(*wxBLACK_PEN);
		memDC->DrawRectangle(pixL,pixT,pixR,pixB); 
	}

//margins
	char *tmp;

	pixL=offX+dbVal("mLeft")*scale;
	pixR=(imageX-dbVal("mRight")-dbVal("mLeft"))*scale;
	pixT=offY+dbVal("mTop")*scale;
	pixB=(imageY-dbVal("mBottom")-dbVal("mTop"))*scale;

	memDC->SetPen(*wxBLACK_DASHED_PEN);
	if ((pixR>0)&&(pixB>0))
		memDC->DrawRectangle(pixL,pixT,pixR,pixB);
	memDC->SetPen(wxNullPen);
	//left margin
	

	if (db->GetValue("reportLayouts","useImage",recordId))
	{
		bcPicture *myImage;
		if (db->GetValue("reportPictures","id",recordId))
		{
			myImage=new bcPicture(db,"reportPictures",recordId,recordId);
			myImage->LoadFromDatabase();
			if (myImage->Ok())
			{
				if ((pixR>0)&&(pixB>0))
				{
				//draw background (scaled or centered)
					if (db->GetValue("reportLayouts","imageScale",recordId)!=NULL)
					{ //scaled
						myImage->Rescale(pixR,pixB);
						memDC->DrawBitmap(myImage->ConvertToBitmap(),pixL,pixT);
					} else { //center
//I need to set the size based on the current scale factor, and inches to pixel conversion
						myImage->Rescale(myImage->GetWidth()*scale/72,myImage->GetHeight()*scale/72);
						memDC->DrawBitmap(myImage->ConvertToBitmap(),
							pixL+(pixR/2)-(myImage->GetWidth()/2),
							pixT+(pixB/2)-(myImage->GetHeight()/2));
					}
				}
			}
			safe_delete(myImage);
		}
	}
	//draw queries
	memDC->SetFont(*wxNORMAL_FONT);
	QRY_ID qry;
	void *row;
	RECORD_ID queryId;
	double qX,qY,qW,qH,scX;
	wxCoord tX,tY;
	tBrush.SetStyle(wxTRANSPARENT);
	tStr.Printf("select id from reportQueries where reportId=%u order by runOrder desc",recordId);
	if (qry=db->Query(tStr.c_str(),tStr.Length())) {
		while (row=db->FetchRow(qry)) {
			if (tmp=db->FetchQueryResult(qry,row,0)) {
				queryId=atoi(tmp);
#define _DBV(f,v) \
				if (tmp=db->GetValue("reportQueryLayouts",f,queryId)) \
				{ v=atof(tmp); } else { v=0; }
				_DBV("x",qX);
				_DBV("y",qY);
				_DBV("width",qW);
				_DBV("height",qH);
#undef _DBV
				pixL=(dbVal("mLeft")+qX)*scale+offX;
				pixT=(dbVal("mTop")+qY)*scale+offY;
				pixR=qW*scale;
				pixB=qH*scale;
				if ((pixL<availX) && (pixT<availY) &&
					 (pixR>0) && (pixB>0))
				{
				if (queryId==this->hotQuery)
				{
					tBrush.SetStyle(wxSOLID);
					tBrush.SetColour("YELLOW");
					memDC->SetTextForeground(wxColour("FIREBRICK"));
		
				} else {
					tBrush.SetStyle(wxSOLID);
					tBrush.SetColour("LIGHT GREY");
				}
				memDC->SetBrush(tBrush);
				memDC->DrawRectangle(pixL,pixT,pixR,pixB);
				memDC->SetBrush(wxNullBrush);
				tBrush.SetColour("LIGHT BLUE");
				memDC->SetBrush(tBrush);

				memDC->DrawRectangle(pixL,pixT,5,5);
				memDC->DrawRectangle(pixL,pixT+pixB-5,5,5);
				memDC->DrawRectangle(pixL+pixR-5,pixT,5,5);
				memDC->DrawRectangle(pixL+pixR-5,pixT+pixB-5,5,5);
				memDC->SetDeviceOrigin(pixL,pixT);
				memDC->GetTextExtent(db->GetValue("reportQueries","name",queryId),&tX,&tY);
				if ((tX*scale > pixR)||(tY*scale > pixB))
				{
					if ((tX*scale / pixR) > (tY*scale / pixB))
						{ scX=pixR/tX; }
					else 
						{ scX=pixB/tY; }
					memDC->SetUserScale(scX,scX);
				}
				memDC->DrawText(db->GetValue("reportQueries","name",queryId),0,0);
	
				memDC->SetDeviceOrigin(0,0);
				memDC->SetUserScale(1,1);
				memDC->SetBrush(wxNullBrush);
				memDC->SetTextForeground(wxColour("BLACK"));
				}
			}
		}
	db->FreeQuery(qry);
	}

	//set the bitmap
	safe_delete(memDC);
	bitmapCtrl->SetBitmap(*bitmap);
	safe_delete(bitmap);
};

void brPreview::Refresh()
{
	DrawPreview();
}

void brPreview::OnMouseDown(wxMouseEvent &event)
{

}

void brPreview::OnMouseUp(wxMouseEvent &event)
{

}

void brPreview::OnMouseDClick(wxMouseEvent &event)
{

}

void brPreview::OnMouseMotion(wxMouseEvent &event)
{

}

void brPreview::OnMouseEnter(wxMouseEvent &event)
{

}

void brPreview::OnMouseLeave(wxMouseEvent &event)
{

}

//IMPLEMENT_DYNAMIC_CLASS(brPreviewEditor,wxDialog)
BEGIN_EVENT_TABLE(brPreviewEditor,wxDialog)
END_EVENT_TABLE()

brPreviewEditor::brPreviewEditor(wxWindow *parent,BOLTdb *db,RECORD_ID recordId) :
wxDialog(parent,-1,"brPreview Editor",wxDefaultPosition)
{
	 this->db=db;
	 this->recordId=recordId;
	SetFont(parent->GetFont());

};

void brPreview::HilightQuery(RECORD_ID query)
{
	this->hotQuery=query;
	this->Refresh();
}
